SELECT OBJECT_NAME(object_id) AS TABLE_NAME,
       avg_fragmentation_in_percent AS frag_pc,
       avg_fragment_size_in_pages AS frag_sz_pg,
       page_count,
       avg_page_space_used_in_percent AS avg_space_used,
       record_count, avg_record_size_in_bytes AS avg_rec_size
FROM   sys.dm_db_index_physical_stats(DB_ID(), NULL, NULL, NULL, 'DETAILED')
WHERE  index_level = 0
  AND  (   object_id = OBJECT_ID('T_LONGUE_LIGNE')
        OR object_id = OBJECT_ID('T_LIGNE'));